## SSL Certificates for Cisco Secure Firewall ASA

### Certificate Requirements

- Cisco Secure Firewall ASA (ASA) requires a server identity certificate for SSL VPN.
- ASA sends the certificate to remote SSL VPN clients for authentication.

### Default Certificate Behavior

- ASA creates a temporary self-signed X.509 certificate on every reboot by default.
- This results in client warnings, as these certificates cannot be verified.

### Solutions for Certificate Warnings

- Create a **persistent self-signed certificate** (remains after reboot).
- Enroll ASA with an **external certificate authority (CA)** and obtain a verifiable certificate (recommended for production).

---

## User Authentication and Connection Profiles

### Connection Profile Selection

- Users select a connection profile via:
    - Drop-down list in Cisco Secure Client (formerly AnyConnect)
    - Group URL
- If no profile is chosen, users are assigned the **DefaultWEBVPNGroup** profile.
- Default profile uses local user database for authentication.

### User Authentication Process

- Users authenticate using a method defined in the connection profile.
- Basic method: username and static password stored locally.
- Successful authentication establishes an SSL VPN session and applies policies.

### Example: Multiple Connection Profiles

- Default profile: local user database
- Custom profile (e.g., ENTERPRISE-CONNECTION): external RADIUS AAA server (e.g., Cisco ISE)

---

## IP Address Assignment for VPN Clients

### Methods of Assignment

1. **IP Address Pool (Connection Profile):**
    - Pool defined on ASA and linked to a connection profile.
    - All users of that profile receive an address from this pool.
    - Optionally, use a DHCP server via the connection profile.
2. **IP Address Pool (Group Policy):**
    - Pool linked to a group policy.
    - All profiles using that group policy share the pool.
3. **Per-User Assignment:**
    - IP address assigned per user in the local database or AAA server.
    - Useful for unique user tracking and auditing.

### Default Behavior

- All IP traffic is forwarded over the VPN tunnel by default.

---

## Split Tunneling

- **Purpose:** Only certain traffic is tunneled to internal networks, other traffic bypasses VPN.
- **Benefits:** Improved performance for general internet access.
- **Risks:** Potential security exposure if client is compromised; may act as a relay between networks.

---

## Access Control for VPN Traffic

### Default Behavior

- VPN traffic is **not** subject to interface ACLs by default.
- All VPN endpoint traffic is allowed.

### Access Control Options

1. **Enable Filtering with Interface ACLs:**
    - Treat VPN traffic like regular interface traffic.
2. **IP Filter Attribute in Group Policy:**
    - Apply an ACL (IP filter) to VPN sessions via group policies for differentiated access.

---

## General Deployment Steps for SSL VPN on ASA

1. **Create Local User Accounts** in the ASA database.
2. **Edit or Create a Group Policy:**
    - Configure Cisco Secure Client (AnyConnect) support.
    - Optionally configure split tunneling.
    - Optionally set local IP pool for client IP assignment.
3. **Enable SSL VPN on an Interface:**
    - Assign identity certificate to the interface.
    - Upload Cisco Secure Client image, if needed.
4. **Edit or Create a Connection Profile:**
    - Allow user to select a profile at login.
    - Choose authentication method (default: local).
    - Assign client address pool if not set in group policy.
    - Configure NAT exemption if NAT is used.
    - Configure ACLs if the default behavior has been changed to restrict VPN traffic.

### Prerequisites

- Identity certificate must be provisioned on ASA.
- Cisco Secure Client image must be installed.

---

## Example: Custom Connection and Group Policy

- **Custom Connection Profile:** e.g., ENTERPRISE-PROFILE, authenticates against local database, points to EMPLOYEES-GROUP policy.
- **Group Policy (EMPLOYEES-GROUP):**
    - Configured with local IP pool, allowed SSL protocols, split tunneling, and ACLs for protected networks.

---

## NAT Exemption

- Required if address translation is enabled.
- NAT exemption ensures VPN client traffic to internal resources is not translated, maintaining original IPs.
- General NAT rules translate other outbound traffic using dynamic PAT.

---

## Verifying and Troubleshooting VPN Configuration

### Steps to Verify Configuration

1. Ensure SSL/TLS session is established (check logs for protocol/cipher issues).
2. Verify successful user authentication (check logs for credential issues).
3. Confirm group policy allows SSL VPN tunnels.
4. Check if ASA assigns an IP address to the client (use logs).

### Troubleshooting Lack of Connectivity

1. **Split Tunneling:**
    - Check client routing table and split tunnel ACLs.
2. **Traffic Denial:**
    - Check ASA logs for denied packets.
3. **NAT Rules:**
    - Use Packet Tracer and NAT table to check rule matches.
4. **Internal Routing:**
    - Verify internal network routes to assigned client IPs.

---

## Key Notes

- **Cisco Secure Client** is the new name for Cisco AnyConnect.
- SSL VPN configuration and deployment require careful planning of certificates, user authentication, IP assignment, access control, and NAT.
- Default behaviors (e.g., ACL bypass, full tunneling) can be modified to suit security and access needs.